/*
 * Decompiled with CFR 0.152.
 */
package com.renyigesai.immortalers_delight.potion.immortaleffects;

import com.renyigesai.immortalers_delight.util.DifficultyModeUtil;
import com.renyigesai.immortalers_delight.util.datautil.EffectData;
import com.renyigesai.immortalers_delight.util.task.TimekeepingTask;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class FreezeEffect {
    private static final Map<UUID, EffectData> entityHasEffect = new ConcurrentHashMap<UUID, EffectData>();

    public static Map<UUID, EffectData> getEntityMap() {
        return entityHasEffect;
    }

    public static void applyImmortalEffect(LivingEntity entity, int duration, int amplifier) {
        if (entity == null || entity.m_213877_() || entity.m_9236_().m_5776_()) {
            return;
        }
        UUID uuid = entity.m_20148_();
        long expireTime = TimekeepingTask.getImmortalTickTime() + (long)duration * 50L;
        EffectData effectData = new EffectData(entity.m_20183_(), expireTime, amplifier, entity.m_217043_().m_188502_());
        entityHasEffect.put(uuid, effectData);
        if (entity instanceof Player) {
            Player player = (Player)entity;
            player.m_5661_((Component)Component.m_237110_((String)"message.immortalers_delight.effect.freeze", (Object[])new Object[0]), true);
        }
    }

    public static void removeImmortalEffect(LivingEntity entity) {
        if (entity == null || entity.m_213877_() || entity.m_9236_().m_5776_()) {
            return;
        }
        UUID uuid = entity.m_20148_();
        if (entityHasEffect.get(uuid) != null) {
            entityHasEffect.remove(uuid);
        }
        FreezeEffect.onImmortalEffectRemove(entity);
    }

    private static void onImmortalEffectRemove(LivingEntity entity) {
    }

    @SubscribeEvent
    public static void onTick(@Nonnull TickEvent.LevelTickEvent evt) {
        if (evt.phase.equals((Object)TickEvent.Phase.START) && entityHasEffect.size() > 0 && TimekeepingTask.getImmortalTickTime() % 1000L * (long)(entityHasEffect.size() + 1) <= 50L) {
            FreezeEffect.CheckAndClearMap(evt.level);
        }
    }

    public static void CheckAndClearMap(Level level) {
        HashMap<UUID, EffectData> needClearMap = new HashMap<UUID, EffectData>();
        for (UUID uuid : entityHasEffect.keySet()) {
            EffectData effectData = entityHasEffect.get(uuid);
            if (effectData == null || TimekeepingTask.getImmortalTickTime() <= effectData.getTime()) continue;
            needClearMap.put(uuid, effectData);
        }
        for (UUID uuid : needClearMap.keySet()) {
            ServerLevel serverLevel;
            Entity entity;
            if (level instanceof ServerLevel && (entity = (serverLevel = (ServerLevel)level).m_8791_(uuid)) instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                FreezeEffect.removeImmortalEffect(living);
                entityHasEffect.remove(uuid);
            }
            if (!level.m_5776_()) continue;
            entityHasEffect.remove(uuid);
        }
    }

    @SubscribeEvent
    public static void onTick(LivingEvent.LivingTickEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity == null || entity.m_213877_() || !entity.m_6084_()) {
            return;
        }
        if (entity.m_9236_().m_5776_()) {
            return;
        }
        UUID uuid = entity.m_20148_();
        if (entityHasEffect.get(uuid) == null) {
            return;
        }
        Long expireTime = entityHasEffect.get(uuid).getTime();
        if (TimekeepingTask.getImmortalTickTime() <= expireTime) {
            entity.m_146924_(true);
            entity.m_146917_(entity.m_146891_() + 4);
            FreezeEffect.spawnParticle((Entity)entity, 1);
            if (entity.f_19797_ % 40 == 20) {
                boolean isPowerful = DifficultyModeUtil.isPowerBattleMode();
                int lv = entityHasEffect.get(uuid).getAmplifier();
                if (isPowerful || lv > 0) {
                    float damage = isPowerful && lv == 0 ? 1.0f : 0.5f;
                    for (int i = 0; i < lv; ++i) {
                        damage *= 2.0f;
                    }
                    float bufferByEntity = 1.0f;
                    if (entity.m_6095_().m_204039_(EntityTypeTags.f_144295_) || isPowerful) {
                        bufferByEntity = 5.0f;
                    }
                    if (entity.m_6095_().m_204039_(EntityTypeTags.f_144294_)) {
                        float f = bufferByEntity = isPowerful ? 1.0f : 0.0f;
                    }
                    if ((damage *= bufferByEntity) > 0.0f) {
                        entity.m_6469_(entity.m_269291_().m_269109_(), damage);
                    }
                }
                int lv1 = lv + 1;
                if (!isPowerful && lv1 > 4) {
                    lv1 = 4;
                }
                MobEffectInstance effect = new MobEffectInstance(MobEffects.f_19597_, 40 + lv1 * 20, lv1);
                entity.m_7292_(effect);
            }
        } else {
            FreezeEffect.removeImmortalEffect(entity);
        }
    }

    private static void spawnParticle(@Nonnull Entity entity, int type) {
        Level level = entity.m_9236_();
        BlockPos pPos = entity.m_20183_().m_6630_(1 + (int)entity.m_20192_());
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (entity.f_19797_ % 3 == 0) {
                Vec3 center = new Vec3((double)pPos.m_123341_() + 0.5, (double)pPos.m_123342_() + 0.5, (double)pPos.m_123343_() + 0.5);
                double radius = entity.m_20205_();
                int i = 0;
                while ((float)i < 1.0f + entity.m_20205_() * 3.0f) {
                    double angle = Math.PI * 2 * Math.random();
                    double r = radius * Math.sqrt(Math.random());
                    double x = center.f_82479_ + r * Math.cos(angle);
                    double z = center.f_82481_ + r * Math.sin(angle);
                    double y = center.f_82480_;
                    if (type == 0) {
                        serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123792_, x, y, z, 1, 0.0, 0.0, 0.0, 0.025);
                    }
                    if (type == 1) {
                        serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_175821_, x, y, z, 1, 0.0, 0.0, 0.0, 0.025);
                    }
                    ++i;
                }
            }
        }
    }
}

